********************************
* This program was run on the NBER mainframe on 29 Jan 2005
* using taxsim v5.1
*******************************

clear
program drop _all
cd /homes/nber/aleigh/
log using stateineq.log, replace
set mem 1000m
set matsize 800
set more off

program define simulate_taxes1
cd /homes/nber/aleigh/
forvalues s=1/51 {
use temp1990_5000, clear 
replace year=$y
  replace state=`s'
  sort state year
  merge state year using faminc_meanmedian, nokeep
  label drop fstate
  replace faminc=faminc*(faminc_median/38640)
  replace _incwag=_incwag*(faminc_median/38640)
 sum faminc
 drop _merge faminc_median faminc_mean
for any agex swages dividends otherprop pensions gssi transfers rentpaid proptax otheritem childcare ui: gen X=0
gen mstat=1
replace mstat=2 if marital<4 & marital~=0 
gen depx=child18
replace agex=1 if age>65
recode faminc min/0=0
gen pwages=faminc
replace pwages=faminc*0.666 if mstat==2
replace swages=faminc*0.333 if mstat==2
gen faminc_adj=faminc/(familysize^.5)
gen faminc_split=faminc/familysize
for any faminc faminc_adj faminc_split: recode X min/1=1
gen wagehr=_incwag/(hrslyr*_wkslyr)
recode wagehr min/1=.
drop occ* ind* inc* _* hhid* lineno recnum* ern* marital*
sort faminc
 replace taxsimid = _n
 sort taxsimid 
 save taxsim_in, replace
 taxsim, temp
 use taxsim_out.dta, clear 
 sort taxsimid 
 merge taxsimid using taxsim_in, keep(wagehr faminc faminc_adj faminc_split age familysize wgt)
 tab _merge
 drop _merge
 compress
 save /homes/nber/aleigh/bulk/taxsim`s'_$y, replace
 }
end

program define simulate_taxes2
forvalues s=1/51 {
 use /homes/nber/aleigh/bulk/taxsim`s'_$y, clear
 gen index=.
 for X in num 1977/2002 \ Y in num 17607.04 19262.67 21217.16 22623.83 24542.5 25884.16 26885.94 29240.22 30658.91 32368.86 33844.87 35602.16 37764.64 38640.56 39202.21 40243.89 41241.48 43098.48 47464.73 49595.78 52432.28 54749.87 56630.34 60715.47 64232.86 64150.74: replace index=Y/65644 if year==X
 for any faminc_adjpt faminc_splitpt tax_adj tax_split famincpt wagehrpt: gen X=.
 replace faminc_adjpt=(faminc-(fiitax+siitax))/(familysize^.5)
 replace faminc_splitpt=(faminc-(fiitax+siitax))/familysize
 replace famincpt=faminc-(fiitax+siitax)
 recode famincpt min/1=1
 gen atr=1-(famincpt/faminc)
 replace atr=. if atr>1 | atr<-1
 replace wagehr=. if age<16 | age>55
 replace wagehrpt=wagehr*(famincpt/faminc) if atr~=.
 replace tax_adj=(fiitax+siitax)/(familysize^.5)
 replace tax_split=(fiitax+siitax)/familysize
 recode faminc_adjpt min/1=1
 recode faminc_splitpt min/1=1
 recode tax_adj min/1=1
 recode tax_split min/1=1
 ineqdeco tax_split [aw = faminc_split] 
 gen suits_split`s' = $S_gini 
 ineqdeco tax_adj [aw = faminc_adj] 
 gen suits_adj`s' = $S_gini 
 ineqdeco faminc_adj [aw = wgt]
 gen gini_adj`s' = $S_gini 
 ineqdeco faminc_split [aw = wgt]
 gen gini_split`s' = $S_gini 
 ineqdeco faminc_adjpt [aw = wgt]
 gen gini_adjpt`s' = $S_gini 
 ineqdeco faminc_splitpt [aw = wgt]
 gen gini_splitpt`s' = $S_gini 
 * S-Ginis, for delta=1.25 (emphasises top), 1.5, 2.5, 3.5 (emphasises bottom)
 * NB. relsgini doesn't save results.
 
 sort wagehr 
 gen n=_n if wagehr~=.
 egen temp=max(n)
 gen N=temp
 drop temp*

 egen temp1=sum(wagehr)
 gen temp2=(((N-n+1)^1.25)-((N-n)^1.25))*wagehr
 egen temp3=sum(temp2)
 egen temp4=mean(wagehr)
 gen sg125_`s'=1-((1/(temp4*(N^1.25)))*temp3)
 drop temp2 temp3 
 gen temp2=(((N-n+1)^1.5)-((N-n)^1.5))*wagehr
 egen temp3=sum(temp2)
 gen sg15_`s'=1-((1/(temp4*(N^1.5)))*temp3)
 drop temp2 temp3 
 gen temp2=(((N-n+1)^2.5)-((N-n)^2.5))*wagehr
 egen temp3=sum(temp2)
 gen sg25_`s'=1-((1/(temp4*(N^2.5)))*temp3)
 drop temp2 temp3 
 gen temp2=(((N-n+1)^2)-((N-n)^2))*wagehr if state == `s'
 egen temp3=sum(temp2) if state == `s'
 gen gini_w`s'=1-((1/(temp4*(N^2)))*temp3) if state == `s'
 drop temp2 temp3 
 gen temp2=(((N-n+1)^3.5)-((N-n)^3.5))*wagehr
 egen temp3=sum(temp2)
 gen sg35_`s'=1-((1/(temp4*(N^3.5)))*temp3)
 drop temp* N n

 sort wagehrpt 
 gen n=_n if wagehrpt~=.
 egen temp=max(n)
 gen N=temp
 drop temp*

 egen temp1=sum(wagehrpt)
 egen temp4=mean(wagehrpt)
 gen temp2=(((N-n+1)^1.25)-((N-n)^1.25))*wagehrpt
 egen temp3=sum(temp2)
 gen sg125pt_`s'=1-((1/(temp4*(N^1.25)))*temp3)
 drop temp2 temp3 
 gen temp2=(((N-n+1)^1.5)-((N-n)^1.5))*wagehrpt
 egen temp3=sum(temp2)
 gen sg15pt_`s'=1-((1/(temp4*(N^1.5)))*temp3)
 drop temp2 temp3 
 gen temp2=(((N-n+1)^2.5)-((N-n)^2.5))*wagehrpt
 egen temp3=sum(temp2)
 gen sg25pt_`s'=1-((1/(temp4*(N^2.5)))*temp3)
 drop temp2 temp3 
 gen temp2=(((N-n+1)^2)-((N-n)^2))*wagehrpt if state == `s'
 egen temp3=sum(temp2) if state == `s'
 gen gini_wpt`s'=1-((1/(temp4*(N^2)))*temp3) if state == `s'
 drop temp2 temp3 
 gen temp2=(((N-n+1)^3.5)-((N-n)^3.5))*wagehrpt
 egen temp3=sum(temp2)
 gen sg35pt_`s'=1-((1/(temp4*(N^3.5)))*temp3)
 gen mtr`s'=(srate+frate)/100
 drop temp* N n fiitax siitax fica* frate srate faminc_adj* faminc_split* famincpt familysize
 for any wagehr wagehrpt faminc atr: ren X X`s'
 collapse year gini* suits* sg* wagehr* faminc* mtr`s' atr`s' (median) atr_median`s'=atr`s'
 sort year
 save /homes/nber/aleigh/bulk/taxes`s'_$y, replace
}
end

***********************************************************
* These next lines run the 3 programs
* First to calculate taxes for 1977+; then to 
* calculate inequality for all years;
* and last to calculate the Suits index for 1977+
* (Note that we have 2 year variables, cpsyear, and earnings year=cpsyear-1)
***********************************************************

* Calculating taxes using 1990 CPS data
forvalues y=1977/2002 {
global y=`y'
 simulate_taxes1 
}

* Calculating tax progressivity & ATR from post-tax data
forvalues y=1977/2002 {
global y=`y'
simulate_taxes2
}


* Putting all the tax files together
forvalues y=1977/2002 {
global y=`y'
use /homes/nber/aleigh/bulk/taxes1_$y, clear
forvalues s=2/51 {
sort year
merge year using /homes/nber/aleigh/bulk/taxes`s'_$y
drop _merge
}
sort year
save /homes/nber/aleigh/tempineq90sim$y, replace 
}

log close
